#pragma semicolon 1

#include <sourcemod>
#include <socket>
#include <regex>

#define PLUGIN_VERSION "1.0.0"

// Api
#define APIPORT 80
#define USERAGENT "SQL_API_Feedback"

new bool:g_bGaveFeedback[MAXPLAYERS + 1];
new Handle:g_hSocket = INVALID_HANDLE;
new Handle:g_cvarHOST = INVALID_HANDLE;

new String:g_sServerInfo[3][32];

public Plugin:myinfo =
{
	name = "SQL API Feedback",
	author = "HSFighter",
	description = "Take client feedback and store it in a MySQL database over an API.",
	version = PLUGIN_VERSION,
	url = "http://sourceserver.info"
};

public OnPluginStart()
{
	CreateConVar("sm_sqlapifeedback_version", PLUGIN_VERSION, "SQL API Feedback Version", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	g_cvarHOST = CreateConVar("sm_sqlapifeedback_host", "yourdomain.com", "Host where the feedback is sent", FCVAR_PLUGIN);
	
	RegConsoleCmd("feedback", Command_Feedback, "feedback <text>");

	GetConVarString(FindConVar("ip"), g_sServerInfo[0], sizeof(g_sServerInfo[]));
	GetConVarString(FindConVar("hostport"), g_sServerInfo[1], sizeof(g_sServerInfo[]));

	AutoExecConfig(true, "plugin.sqlapifeedback");
}

public OnClientPutInServer(client)
{
	g_bGaveFeedback[client] = false;
}

//////////////////////////////////////////////////////////////////
// Send Feedback
//////////////////////////////////////////////////////////////////

public Action:Command_Feedback(client, args)
{
	if (args < 1)
	{
		ReplyToCommand(client, "[SM] Usage: feedback <text>");
		return Plugin_Handled;
	}

	if (g_bGaveFeedback[client])
	{
		ReplyToCommand(client, "[SM] You can only use this command every 10 seconds!");
		return Plugin_Handled;
	}

	decl String:sText[255];
	GetCmdArgString(sText, sizeof(sText));
	
	ReplaceString(sText, sizeof(sText), " ", "%20", true);
	
	new Handle:pack = CreateDataPack();
	
	WritePackCell(pack, client);
	WritePackString(pack, sText);

	new String:cvar_host[254];
	GetConVarString(g_cvarHOST, cvar_host, sizeof(cvar_host));
	
	if (IsClientAuthorized(client) && !IsClientBot(client))
	{
		g_hSocket = SocketCreate(SOCKET_TCP, Network_OnSocketError);
		SocketSetArg(g_hSocket, pack);
		SocketSetOption(g_hSocket, SocketSendTimeout, 5160);
		SocketSetOption(g_hSocket, SocketReceiveTimeout, 5160);
		SocketConnect(g_hSocket, Network_OnSocketConnect, Network_OnSocketReceive, Network_OnSocketDisconnect, cvar_host, APIPORT);
	}

	g_bGaveFeedback[client] = true;
	CreateTimer(10.0, Timer_ChangeSpam, client, TIMER_FLAG_NO_MAPCHANGE);

	return Plugin_Continue;
}

//////////////////////////////////////////////////////////////////
// Timer to prevent Spam
//////////////////////////////////////////////////////////////////

public Action:Timer_ChangeSpam(Handle:timer, any:client)
{
	g_bGaveFeedback[client] = false;
}

//////////////////////////////////////////////////////////////////
// Functions
//////////////////////////////////////////////////////////////////

public bool:IsClientBot(client)
{
	decl String:SteamID[64];
	// Get Steam ID
	GetClientAuthString(client, SteamID, sizeof(SteamID));
	
	//Check if BOT
	if (!IsFakeClient(client) && !StrEqual(SteamID, "BOT") && !StrEqual(SteamID, "STEAM_ID_PENDING")) return false;

	return true;
}

stock GetXMLNodeData(const String:XML[], const String:node[], String:buffer[], maxlen)
{
	decl String:pattern[256];
	Format(pattern, sizeof(pattern), "(<%s>)([A-Za-z0-9:_]+)(</%s>)", node, node);
	static Handle:re = INVALID_HANDLE;
	if (re == INVALID_HANDLE)
	{
		re = CompileRegex(pattern);
	}

	if (MatchRegex(re, XML) >= 1)
	{
		GetRegexSubString(re, 2, buffer, maxlen);
	}
	else
	{
		strcopy(buffer, maxlen, "No match found!");
	}
}

public Network_OnSocketConnect(Handle:socket, any:pack)
{	
	if ( !SocketIsConnected(socket) ) return;
	
	ResetPack(pack);
	
	new Client = ReadPackCell(pack);
	
	new  String:buffer[1024];
	ReadPackString(pack, buffer, 1024);
	
	decl String:f_sAuthID[64];
	decl String:requestStr[400];
	
	if ( !IsClientAuthorized(Client) || !GetClientAuthString(Client, f_sAuthID, sizeof(f_sAuthID)) )
	{
		SocketDisconnect(socket);
	}
	else
	{
		new String:cvar_host[254];
		GetConVarString(g_cvarHOST, cvar_host, sizeof(cvar_host));
		
		Format(requestStr, sizeof(requestStr), "GET /%s?steam=%s&text=%s&ip=%s&port=%s HTTP/1.0\r\nHost: %s\r\nUser-Agent: %s\r\nConnection: close\r\n\r\n", "feedback.php",f_sAuthID, buffer, g_sServerInfo[0], g_sServerInfo[1], cvar_host, USERAGENT);
		SocketSend(socket, requestStr);		
	}
	return;
}


public Network_OnSocketDisconnect(Handle:socket, any:pack)
{
	if ( socket == g_hSocket )
		g_hSocket = INVALID_HANDLE;
	CloseHandle(socket);
	return;
}

public Network_OnSocketReceive(Handle:socket, String:data[], const size, any:pack) 
{
	ResetPack(pack);
	
	new Client = ReadPackCell(pack);
	
	if ( socket == INVALID_HANDLE || !IsClientAuthorized(Client) ) return;
	
	decl String:status[256];
	GetXMLNodeData(data, "return", status, sizeof(status));

	decl String:f_sAuthID[64];
	GetClientAuthString(Client, f_sAuthID, sizeof(f_sAuthID));
	
	
	// Here can be handled errolevels from .php file
	
	if ( StrEqual(status, "0") )
	{		
		LogMessage("Added feedback from user %N (%s)", Client, f_sAuthID);
		PrintToChat(Client, "[SM] Thank you for your feedback!");
	}
	else if ( StrEqual(status, "8") )
	{
		LogMessage("Useragent %s not equal with useragent in .php file!", USERAGENT);
	}
	else
	{
		LogMessage ("Got unknown reply from master server. Data: %s", status);
	}
	
	if ( SocketIsConnected(socket) ) SocketDisconnect(socket);
}

public Network_OnSocketError(Handle:socket, const errorType, const errorNum, any:pack)
{
	if ( socket == INVALID_HANDLE ) return;
	if ( g_hSocket == socket ) g_hSocket = INVALID_HANDLE;
	CloseHandle(socket);
}