<?php
/**
 * =============================================================================
 * @Script: SQL API Feedback
 *
 * @author: HSFighter
 * @file: index.php
 * @version: 1.0.0
 * @date: 25.06.13
 * @link: http://sourceserver.info
 * 
 * =============================================================================
 */
 
// Setup DB Connection 
define('mysql_host','localhost'); 	// DB hostname
define('mysql_port','3306');		// DB port (Default: 3306)
define('mysql_db','');				// DB name
define('mysql_user','');			// DB username
define('mysql_pass','');			// DB password
define('mysql_prefix','sqlfb'); 	// DB tableprefix

// Other Settings
define('useragent','SQL_API_Feedback'); // Musst be simalar to "#define USERAGENT" in SM-Plugin!!!

// ==============================================================================
// ==============================================================================

// Create DB Connection
try {
    $connection=new PDO('mysql:host='.mysql_host.';port='.mysql_port.';charset=utf8;dbname='.mysql_db,mysql_user,mysql_pass,array(PDO::MYSQL_ATTR_INIT_COMMAND=>"SET NAMES utf8"));	
	// Stop PHP and throw exception in case of any SQL Notice and Error.
    $connection->setAttribute(PDO::ATTR_ERRMODE,PDO::ERRMODE_EXCEPTION);
}
catch(PDOException $error) {
    die($error->getMessage());
}

// Get data from address field
$steamid = (isset($_GET['steam'])) ? $_GET['steam']:'';
$text = (isset($_GET['text'])) ? $_GET['text']:'';
$ip = (isset($_GET['ip'])) ? $_GET['ip']:'';
$port = (isset($_GET['port'])) ? $_GET['port']:'';


// Filter SQL injection
foreach($_GET as $key => $value){
	if(get_magic_quotes_gpc()) $_GET[$key] = stripslashes($value);
	$_GET[$key] = mysql_escape_mimic( $value );
}

	if (isset($_SERVER['HTTP_USER_AGENT'])){
		$agent = $_SERVER['HTTP_USER_AGENT'];
	}else{
		$agent = '';
	}	

// Validate data
if ($steamid == '')
{
	$errorlevel = 1; // Set no SteamID found
}
else if ($text == '')
{
	$errorlevel = 2; // Set no Feddback found
}
else if ($ip == '')
{
	$errorlevel = 3; // Set no IP Found
}
else if ($port == '')
{
	$errorlevel = 4; // Set no PORT Found
}
else if (!preg_match('/\bSTEAM_([0-9]{1}):([0-9]{1}):([0-9])+$/',$steamid))
{
	$errorlevel = 5; // Set wrong SteamID
}
else if (!filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4))
{
	$errorlevel = 6; // Set wrong ip
}
else if (!is_numeric($port))
{
	$errorlevel = 7; // Set wrong port
}
else if ($agent != useragent)
{
	$errorlevel = 8; // Wrong useragent
}
else
{
	// Prepare for insert and save data to DB
	$save_feedback=$connection->prepare("INSERT INTO `".mysql_prefix."_feedback` (`steamid`,`serverip`,`serverport`,`feedback`) VALUES (?,?,?,?)");
	$save_feedback->execute(array($steamid,$ip,$port,$text)); 
	$errorlevel = 0; // Set feedback ok
}

$xmlstr="<?xml version='1.0' standalone='yes'?>";
$xmlstr .="<feedback>";
$xmlstr .="<return>".$errorlevel ."</return>";
$xmlstr .="</feedback>";

header('Content-type: text/xml');
echo $xmlstr;

// ================================================= Functions =================================================

function mysql_escape_mimic($inp) {
    if(is_array($inp))
        return array_map(__METHOD__, $inp);

    if(!empty($inp) && is_string($inp)) {
        return str_replace(array('\\', "\0", "\n", "\r", "'", '"', "\x1a"), array('\\\\', '\\0', '\\n', '\\r', "\\'", '\\"', '\\Z'), $inp);
    }
    return $inp;
} 

// =============================================================================================================

?>