/**
 * vim: set ts=4 :
 * =============================================================================
 * SourceMod Sample Extension
 * Copyright (C) 2004-2008 AlliedModders LLC.  All rights reserved.
 * =============================================================================
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, version 3.0, as published by the
 * Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * As a special exception, AlliedModders LLC gives you permission to link the
 * code of this program (as well as its derivative works) to "Half-Life 2," the
 * "Source Engine," the "SourcePawn JIT," and any Game MODs that run on software
 * by the Valve Corporation.  You must obey the GNU General Public License in
 * all respects for all other code used.  Additionally, AlliedModders LLC grants
 * this exception to all derivative works.  AlliedModders LLC defines further
 * exceptions, found in LICENSE.txt (as of this writing, version JULY-31-2007),
 * or <http://www.sourcemod.net/license.php>.
 *
 * Version: $Id$
 */

#include "extension.h"

/**
 * @file extension.cpp
 * @brief Implement extension code here.
 */

Sample g_Sample;		/**< Global singleton for extension's main interface */

SMEXT_LINK(&g_Sample);

IGameConfig *g_pGameConf = NULL;
CDetour *DSetLocalAngles = NULL;

// Avoid inclusion of hl2sdks

float k_flMaxEntityEulerAngle = 360.0 * 1000.0f; // really should be restricted to +/-180, but some code doesn't adhere to this.  let's just trap NANs, etc

class QAngle
{
public:
	// Members
	float x, y, z;
};

inline bool IsEntityQAngleReasonable(const QAngle &q)
{
	float r = k_flMaxEntityEulerAngle;
	return
		q.x > -r && q.x < r &&
		q.y > -r && q.y < r &&
		q.z > -r && q.z < r;
}

DETOUR_DECL_MEMBER1(DetourSetLocalAngles, void, QAngle &, angles)
{
	if (!IsEntityQAngleReasonable(angles))
	{
		while (angles.x > k_flMaxEntityEulerAngle)
			angles.x -= k_flMaxEntityEulerAngle;
		while (angles.y > k_flMaxEntityEulerAngle)
			angles.y -= k_flMaxEntityEulerAngle;
		while (angles.z > k_flMaxEntityEulerAngle)
			angles.z -= k_flMaxEntityEulerAngle;
	}

	return DETOUR_MEMBER_CALL(DetourSetLocalAngles)(angles);
}

bool Sample::SDK_OnLoad(char *error, size_t maxlength, bool late)
{
	char conf_error[255];
	if (!gameconfs->LoadGameConfigFile("setlocalanglesclamp.games", &g_pGameConf, conf_error, sizeof(conf_error)))
	{
		if (error)
		{
			snprintf(error, maxlength, "Could not read setlocalanglesclamp.games.txt: %s", conf_error);
		}
		return false;
	}

	CDetourManager::Init(smutils->GetScriptingEngine(), g_pGameConf);
	DSetLocalAngles = DETOUR_CREATE_MEMBER(DetourSetLocalAngles, "SetLocalAngles");

	if (DSetLocalAngles == NULL)
	{
		if (error)
		{
			snprintf(error, maxlength, "Could not create detour for SetLocalAngles.");
		}
		return false;
	}
	DSetLocalAngles->EnableDetour();

	return true;
}

void Sample::SDK_OnUnload()
{
	gameconfs->CloseGameConfigFile(g_pGameConf);
	if (DSetLocalAngles != NULL)
		DSetLocalAngles->Destroy();
	DSetLocalAngles = NULL;

}