#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#include <multicolors>

#define PLUGIN_NAME "Spray Height"

#pragma newdecls required

ConVar g_cUnit = null;
ConVar g_cTag = null;

public Plugin myinfo =
{
	name = PLUGIN_NAME,
	author = "Bara",
	version = "2.0.0",
	description = "",
	url = "git.tf/Bara"
};

public void OnPluginStart()
{
	if(GetEngineVersion() != Engine_CSS)
	{
		SetFailState("Only CS:S Support!");
		return;
	}
	
	// 0 - unit, 1 - mm, 2 - cm
	g_cUnit = CreateConVar("spray_unit", "0", "0 = unit, 1 = mm, 2 = cm", _, true, 0.0, true, 2.0);
	g_cTag = CreateConVar("spray_tag", "{darkred}[Spray] {lightgreen}", "Colored plugin tag");
	
	AddTempEntHook("Player Decal", Hook_PlayerDecal);

	LoadTranslations("sprayheight.phrases");
}

public Action Hook_PlayerDecal(char[] szTempEntName, const arrClients[], int iClientCount, float flDelay)
{
	int client = TE_ReadNum("m_nPlayer");

	if(IsClientInGame(client))
	{
		float fSpray[3];
		float fUp[3];
		float fDown[3];
		TE_ReadVector("m_vecOrigin", fSpray);
		
		float f90[3] =  { 90.0, 0.0, 0.0 };
		float f900[3] =  { -90.0, 0.0, 0.0 };

		TR_TraceRayFilter(fSpray, f90, MASK_PLAYERSOLID, RayType_Infinite, TraceRayFilter, client);
		TR_GetEndPosition(fDown);

		TR_TraceRayFilter(fSpray, f900, MASK_PLAYERSOLID, RayType_Infinite, TraceRayFilter, client);
		TR_GetEndPosition(fUp);

		if(GetVectorDistance(fSpray, fUp) > 0.0 && GetVectorDistance(fSpray, fDown) > 0.0)
		{
			char sTag[32];
			g_cTag.GetString(sTag, sizeof(sTag));
			
			if(GetVectorDistance(fSpray, fUp) < 32.0 || GetVectorDistance(fSpray, fDown) < 32.0)
			{
				for (int i = 1; i <= MaxClients; i++)
					if(IsClientInGame(i))
						CPrintToChat(i, "%T", "SprayTouched", i, sTag, client);
			}
			else
			{
				for (int i = 1; i <= MaxClients; i++)
				{
					if(IsClientInGame(i))
					{
						if(g_cUnit.IntValue == 0)
						{
							char sBuffer[8];
							Format(sBuffer, sizeof(sBuffer), "%T", "Unit_units", i);

							CPrintToChat(i, "%T", "Sprayed", i, sTag, client, ((GetVectorDistance(fSpray, fDown) - 32.0)), sBuffer);
						}
						else if(g_cUnit.IntValue == 1)
						{
							char sBuffer[8];
							Format(sBuffer, sizeof(sBuffer), "%T", "Unit_mm", i);

							CPrintToChat(i, "%T", "Sprayed", i, sTag, client, ((GetVectorDistance(fSpray, fDown) - 32.0) * 1000), sBuffer);
						}
						else if(g_cUnit.IntValue == 2)
						{
							char sBuffer[8];
							Format(sBuffer, sizeof(sBuffer), "%T", "Unit_cm", i);

							CPrintToChat(i, "%T", "Sprayed", i, sTag, client, ((GetVectorDistance(fSpray, fDown) - 32.0) * 100), sBuffer);
						}
					}
				}
			}
		}
	}
}

public bool TraceRayFilter(int entity, int mask, any data)
{
	if(entity != 0)
		return false;
	return true;
}
