﻿Public Class CustomData
    Dim path As String = Main.path
    Public InstallDir As String
    Public DownloadDir As String

    'Init Function:
    Public Sub init()
        If My.Computer.FileSystem.DirectoryExists(InstallDir) = False Then My.Computer.FileSystem.CreateDirectory(InstallDir)
        If My.Computer.FileSystem.DirectoryExists(DownloadDir) = False Then My.Computer.FileSystem.CreateDirectory(DownloadDir)
    End Sub

    'Fills Download-Listbox:
    Public Sub SearchFilesDownload()
        Dialog7.Down.Items.Clear()
        For Each FoundFile As String In My.Computer.FileSystem.GetFiles(path & DownloadDir)
            Dialog7.Down.Items.Add(GetName(FoundFile))
        Next
    End Sub

    'Fills Installed-Listbox:
    Public Sub SearchFilesInstalled()
        Dialog7.Install.Items.Clear()
        For Each FoundFile As String In My.Computer.FileSystem.GetFiles(path & InstallDir)
            Dialog7.Install.Items.Add(GetName(FoundFile))
        Next
    End Sub

    'Moves a item from installed to downloaded:
    Public Sub MoveToDownloaded(ByVal file As String)
        'Wenn Datei schon existiert:
        If My.Computer.FileSystem.FileExists(path & DownloadDir & GetName(file)) Then
            My.Computer.FileSystem.DeleteFile(file)
            Exit Sub
        End If
        My.Computer.FileSystem.MoveFile(file, path & DownloadDir & GetName(file))
    End Sub

    'moves a item from downloaded to installed:
    Public Sub MoveToInstalled(ByVal file As String)
        'Wenn Datei schon existiert:
        If My.Computer.FileSystem.FileExists(path & InstallDir & GetName(file)) Then
            My.Computer.FileSystem.DeleteFile(file)
            Exit Sub
        End If
        My.Computer.FileSystem.MoveFile(file, path & InstallDir & GetName(file))
    End Sub

    'Function for getting a name of a long path:
    Public Function GetName(ByVal location As String) As String
        Dim splitPath() As String
        splitPath = location.Split("\")
        Return splitPath(splitPath.Length - 1)
    End Function

    'Function to get a extention from a name:
    Public Function GetExtention(ByVal name As String, ByVal number As Integer) As String
        Dim splitName() As String
        splitName = name.Split(".")
        Return splitName(splitName.Length - number)
    End Function

    'Searching Dir for sounds:
    Public Sub SearchInstallFiles(ByVal SourceDir As String, ByVal TargetDir As String, ByVal ext1 As String, ByVal ext2 As String, ByVal SubDirectories As Boolean)
        'Subdirectory or not:
        Dim SearchOption As Microsoft.VisualBasic.FileIO.SearchOption = FileIO.SearchOption.SearchTopLevelOnly
        If SubDirectories = True Then SearchOption = FileIO.SearchOption.SearchAllSubDirectories

        Dim i As Integer = 0
        For Each foundFile As String In My.Computer.FileSystem.GetFiles(SourceDir, SearchOption)
            If foundFile.EndsWith(ext1) Or foundFile.EndsWith(ext2) Then
                My.Computer.FileSystem.CopyFile(foundFile, TargetDir & GetName(foundFile))
                i += 1
            End If
        Next


    End Sub

    'Abspielen eines sounds:
    Public Sub PlaySound(ByVal Sound As String)
        With Dialog7.AxWindowsMediaPlayer1
            .URL = Sound
            .Ctlcontrols.play()
        End With

        My.Application.DoEvents()
    End Sub

    'Function to create the mani-files:
    Public Sub CreateSoundlist()
        'Pfade:
        Dim main As String = path & "sound\admin_plugin\"
        Dim main2 As String = path & "cfg\mani_admin_plugin\soundlist.txt"
        Dim main3 As String = path & "cfg\mani_admin_plugin\downloads.txt"
        Dim main4 As String = path & "cfg\mani_admin_plugin\commandlist.txt"

        'Listen:
        Dim filelist As String
        Dim downloadlist As String
        Dim commandlist As String

        'Pfade:
        Dim FilePath As String = main
        Dim FileName As String = ""
        Dim FileTyp As String

        'Zähler:
        Dim counter As Integer = 0
        Dim countermp3 As Integer = 0
        Dim counterwav As Integer = 0
        Dim countererror As Integer = 0


        'Writing Start:
        My.Computer.FileSystem.WriteAllText(main2, "//---------------------------------" & vbCrLf, False)
        My.Computer.FileSystem.WriteAllText(main3, "//---------------------------------" & vbCrLf & """downloads.txt""{""downloads""{" & vbCrLf, False)
        My.Computer.FileSystem.WriteAllText(main4, vbCrLf & "//-----------------------------------", False)


        'Search Directory for Soundfiles:
        For Each foundfile As String In My.Computer.FileSystem.GetFiles(main, FileIO.SearchOption.SearchTopLevelOnly)
            'Vor Überlastung schützen:
            My.Application.DoEvents()

            'String formatieren:
            FileName = GetName(foundfile)
            FileTyp = "." & GetExtention(FileName, 1)
            FileName = GetExtention(GetName(foundfile), 2)

            'Counter erhöhen:
            If FileTyp = ".wav" Then
                counterwav += 1
            ElseIf FileTyp = ".mp3" Then
                countermp3 += 1
            Else
                countererror += 1
            End If
            counter += 1

            'Creating SpecificString:
            filelist = """" & FileName & """ " & FilePath & FileName & FileTyp
            downloadlist = """" & FileName & """ """ & FilePath & FileName & FileTyp & """"
            commandlist = """" & FileName & """ C ma_play " & FileName & "; say ö" & FileName

            'Write Strings: 
            My.Computer.FileSystem.WriteAllText(main2, vbCrLf & filelist, True)
            My.Computer.FileSystem.WriteAllText(main3, vbCrLf & downloadlist, True)
            My.Computer.FileSystem.WriteAllText(main4, vbCrLf & commandlist, True)
        Next


        My.Computer.FileSystem.WriteAllText(main2, vbCrLf & "//END OF THE FILE", True)
        My.Computer.FileSystem.WriteAllText(main3, vbCrLf & "}}" & vbCrLf & "//END OF THE FILE", True)
        My.Computer.FileSystem.WriteAllText(main4, vbCrLf & vbCrLf & "//END OF THE FILE", True)

        'Quit Programm:
        MsgBox("Soundlist has been Created!" & vbCrLf & "All files: " & counter & vbCrLf & "mp3 files: " & countermp3 & vbCrLf & "wav files: " & counterwav & vbCrLf & "other files: " & countererror)
    End Sub
End Class
