﻿Imports System.Windows.Forms

Public Class Dialog1
    Dim gameType As String = ""
    Dim gamePath As String = ""

    Private Sub OK_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles OK_Button.Click
        If gamePath = "" Then
            MsgBox("Enter a path first!")
            Exit Sub
        End If
        Me.DialogResult = System.Windows.Forms.DialogResult.OK
        Dialog2.Show()
        Me.Visible = False
    End Sub

    Private Sub Cancel_Button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Cancel_Button.Click
        Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Me.Close()
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        FolderBrowserDialog1.ShowNewFolderButton = False
        FolderBrowserDialog1.ShowDialog()
        gamePath = FolderBrowserDialog1.SelectedPath.ToString
        If gamePath.EndsWith(gameType) Then
            TextBox1.Text = gamePath
        Else
            MsgBox("Path is not correct! Make sure your path is: ""C:\AnyProgrammPath\STEAM\Steamapps\YourNick\" & gameType & """")
            Exit Sub
        End If
        gamePath += "\"
        Main.path = gamePath
        OK_Button.Enabled = True
    End Sub

    Private Sub ComboBox1_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox1.SelectedIndexChanged
        TextBox1.Text = ""
        gamePath = ""
        Main.path = ""
        gameType = getGameType(ComboBox1.SelectedIndex)
        Label2.Text = "Please enter your " & gameType & " path!"
        Button1.Enabled = True
    End Sub

    Function getGameType(ByVal Index As Integer) As String
        Select Case Index
            Case 0
                Return "cstrike"
            Case 1
                Return "dod"
            Case 2
                Return "hl2mp"
            Case 3
                Return "tf"
            Case Else
                Return "cstrike"
        End Select
    End Function

    Private Sub Dialog1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Label2.Text = ""
    End Sub
End Class
