//////////////////////////////////////////////////////////////////
// Mapend Action By HSFighter / http://www.hsfighter.net"       //
//////////////////////////////////////////////////////////////////

#include <sourcemod>
#include <sdktools>
#pragma semicolon 1
#define PLUGIN_VERSION "3.1"

//////////////////////////////////////////////////////////////////
// Delcare Variables and Handles
//////////////////////////////////////////////////////////////////

new Handle:CvarMCenabled;
new Handle:CvarMCslayenabled;
new Handle:CvarMCdebug;
new Handle:TimeHandle;

new g_MapendTemp = 0;

//////////////////////////////////////////////////////////////////
// Plugin Info
//////////////////////////////////////////////////////////////////

public Plugin:myinfo =
{
	name = "Simple Mapend Countdown",
	author = "HSFighter",
	description = "Mapendaction with countdown",
	version = PLUGIN_VERSION,
	url = "http://www.hsfighter.net"
}

//////////////////////////////////////////////////////////////////
// Start Plugin
//////////////////////////////////////////////////////////////////

public OnPluginStart()
{
	CreateConVar("sm_mapend_countdown_version", PLUGIN_VERSION, "Mapend Action Version", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	CvarMCenabled = CreateConVar("sm_mapend_countdown_enabled", "1", "Enable/disable mapend action.");
	CvarMCdebug = CreateConVar("sm_mapend_countdown_debug", "0", "Debug countdown.");
	CvarMCslayenabled = CreateConVar("sm_mapend_countdown_slay_enabled", "0", "Slay all players on mapend.");	
	
	AutoExecConfig(true, "plugin.simple_mapend");
}

//////////////////////////////////////////////////////////////////
// Start Map
//////////////////////////////////////////////////////////////////

public OnMapStart(){

	PrecacheSound( "hl1/fvox/beep.wav", true);
	PrecacheSound( "fvox/ten.wav", true);
	PrecacheSound( "fvox/nine.wav", true);
	PrecacheSound( "fvox/eight.wav", true);
	PrecacheSound( "fvox/seven.wav", true);
	PrecacheSound( "fvox/six.wav", true);
	PrecacheSound( "fvox/five.wav", true);
	PrecacheSound( "fvox/four.wav", true);
	PrecacheSound( "fvox/three.wav", true);
	PrecacheSound( "fvox/two.wav", true);
	PrecacheSound( "fvox/one.wav", true);


	AddFileToDownloadsTable("sound/fvox/ten.wav");
	AddFileToDownloadsTable("sound/fvox/nine.wav");
	AddFileToDownloadsTable("sound/fvox/eight.wav");
	AddFileToDownloadsTable("sound/fvox/seven.wav");
	AddFileToDownloadsTable("sound/fvox/six.wav");
	AddFileToDownloadsTable("sound/fvox/five.wav");
	AddFileToDownloadsTable("sound/fvox/four.wav");
	AddFileToDownloadsTable("sound/fvox/three.wav");
	AddFileToDownloadsTable("sound/fvox/two.wav");
	AddFileToDownloadsTable("sound/fvox/one.wav");

	g_MapendTemp = 0;

	TimeHandle = CreateTimer(0.5, Checktime, INVALID_HANDLE, TIMER_REPEAT);

}

//////////////////////////////////////////////////////////////////
// Timer
//////////////////////////////////////////////////////////////////

public Action:Checktime(Handle:timer)
{
	if (GetConVarBool(CvarMCenabled)) {

		new timeleft;
		GetMapTimeLeft(timeleft);
		timeleft = timeleft + 1;
		
		if (g_MapendTemp != timeleft)
		{
			g_MapendTemp = timeleft;
			if (GetConVarBool(CvarMCdebug)) PrintToChatAll("Debug: %i Sec. left",timeleft);
		
			switch (timeleft)
			{
				case 1200:
				{
					EmitSoundToAll("hl1/fvox/beep.wav");
					PrintToChatAll("Endmap in 20 Min...");
				}
				case 600:
				{			
					EmitSoundToAll("hl1/fvox/beep.wav");
					PrintToChatAll("Endmap in 10 Min...");
				}			
				case 300:
				{			
					EmitSoundToAll("hl1/fvox/beep.wav");
					PrintToChatAll("Endmap in 5 Min...");
				}	
				case 60:
				{			
					EmitSoundToAll("hl1/fvox/beep.wav");
					PrintToChatAll("Endmap in 60 Sec...");
				}	
				case 30:
				{
					EmitSoundToAll("hl1/fvox/beep.wav");
					PrintToChatAll("Endmap in 30 Sec...");
				}
				case 20:
				{			
					EmitSoundToAll("hl1/fvox/beep.wav");
					PrintToChatAll("Endmap in 20 Sec...");
				}	
				case 10:
				{			
					EmitSoundToAll("fvox/ten.wav");	
					PrintToChatAll("Endmap in 10 Sec...");
				}
				case 9:
				{			
					EmitSoundToAll("fvox/nine.wav");
					PrintToChatAll("Endmap in 9 Sec...");
				}	
				case 8:
				{
					EmitSoundToAll("fvox/eight.wav");
					PrintToChatAll("Endmap in 8 Sec...");
				}	
				case 7:
				{			
					EmitSoundToAll("fvox/seven.wav");
					PrintToChatAll("Endmap in 7 Sec...");
				}		
				case 6:
				{			
					EmitSoundToAll("fvox/six.wav");
					PrintToChatAll("Endmap in 6 Sec...");
				}		
				case 5:
				{			
					EmitSoundToAll("fvox/five.wav");
					PrintToChatAll("Endmap in 5 Sec...");
				}			
				case 4:
				{			
					EmitSoundToAll("fvox/four.wav");
					PrintToChatAll("Endmap in 4 Sec...");
				}
				case 3:
				{			
					EmitSoundToAll("fvox/three.wav");
					PrintToChatAll("Endmap in 3 Sec...");
				}
				case 2:
				{			
					EmitSoundToAll("fvox/two.wav");
					PrintToChatAll("Endmap in 2 Sec...");
				}
				case 1:
				{			
					EmitSoundToAll("fvox/one.wav");
					ServerCommand("mp_ignore_round_win_conditions 0");
					ServerCommand("cssdm_enabled 0");	
					PrintToChatAll("Endmap in 1 Sec...");
				}
			}

			if (timeleft <= 0)
			{
				if (GetConVarBool(CvarMCslayenabled)) ServerCommand("sm_slay @all");
				CloseHandle(TimeHandle);
				return Plugin_Stop;
			}
		}
	}
	return Plugin_Handled;
}

//////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////


public OnMapEnd()
{

}


public OnPluginEnd()
{
	
}

//////////////////////////////////////////////////////////////////
// End Plugin
////////////////////////////////////////////////////////////////// 