// Events triggered by ba_bank

// No spaces in event names, max length 32
// All strings are case sensitive
// total game event byte length must be < 1024
//
// valid data key types are:
//   none   : value is not networked
//   string : a zero terminated string
//   bool   : unsigned int, 1 bit
//   byte   : unsigned int, 8 bit
//   short  : signed int, 16 bit
//   long   : signed int, 32 bit
//   float  : float, 32 bit

"ba_bank"
{
	"bank_deposit"
	{
		"userid"        "short"         // player depositing money
		"amount"        "long"          // amount of money being deposited
	}
	"bank_withdraw"
	{
		"userid"        "short"         // player withdrawing money
		"amount"        "long"          // amount of money being withdrawn
	}
	"bank_transfer"
	{
    "userid"        "short"         // player transferring money
    "receiver"      "short"         // player receiving money
    "amount"        "long"          // amount of money being transferred
  }
  "bank_admin_cash"
  {
    "userid"        "short"         // admin giving money
    "receiver"      "short"         // player receiving money
    "amount"        "long"          // amount of money being given
  }
}
