#include <sourcemod>
#include <sdktools>

#pragma semicolon 1
#define MAX_FILE_LEN 80

new Handle:g_CvarSoundName = INVALID_HANDLE;
new String:g_soundName[MAX_FILE_LEN];
new bool:HadMessage[MAXPLAYERS+1];


#define PLUGIN_VERSION "0.0.1"
public Plugin:myinfo = 
{
	name = "Welcome Sound",
	author = "R-Hehl",
	description = "Plays Welcome Sound to connecting Players",
	version = PLUGIN_VERSION,
	url = "http://www.compactaim.de/"
}




public OnPluginStart()
{
	// Create the rest of the cvar's
	CreateConVar("sm_welcome_snd_version", PLUGIN_VERSION, "Welcome Sound Version", FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY);
	g_CvarSoundName = CreateConVar("sm_join_sound", "joinsound/joinserver.mp3", "The sound to play");
	HookConVarChange(g_CvarSoundName, OnCvarChange);
	RegConsoleCmd("sm_stopsound", Command_StopSound);
	LoadTranslations("joinsound.phrases");
	AddCommandListener(Listener, "joinclass");
}




public OnCvarChange(Handle:cvar, String:oldVal[], String:newVal[])
{
	GetConVarString(g_CvarSoundName, g_soundName, MAX_FILE_LEN);
}




public OnConfigsExecuted()
{
	GetConVarString(g_CvarSoundName, g_soundName, MAX_FILE_LEN);
	decl String:buffer[MAX_FILE_LEN];
	PrecacheSound(g_soundName, true);
	Format(buffer, sizeof(buffer), "sound/%s", g_soundName);
	AddFileToDownloadsTable(buffer);
}




public Action:Command_StopSound(client, args)
{
	if(client >0 && IsClientConnected(client) && IsClientInGame(client))
	{
		StopSound(client, SNDCHAN_AUTO, g_soundName);
	}
	
}




public OnClientPostAdminCheck(client)
{
	EmitSoundToClient(client, g_soundName);
}




public Action:Listener(client, const String:command[], argc)
{
	if(!HadMessage[client])
	{
		PrintToChat(client, "%t", "StopSound_End");
	}
}



/* Wenn die Messages resettet werden sollen einfach auskommentieren
public OnMapEnd()
{
	new len = sizeof(HadMessage);
	for(new i; i < len; i++)
	{
		HadMessage[i] = false;
	}
}
*/

	